# Jasmine NPM 4.0.0 Release Notes

## Summary

This is a major release. In addition to new features and bug fixes it contains
a variety of breaking changes that are intended to improve ES module support,
improve awkward or outdated interfaces, and make Jasmine easier to maintain
and contribute to. If you're upgrading from Jasmine 3.x, we recommend installing
3.99 and fixing any deprecation warnings that it emits before updating to 4.0.
See the [migration guide](https://jasmine.github.io/tutorials/upgrading_to_Jasmine_4.0)
for more information. Be sure to read the release notes for `jasmine-core` 4.0.0
as well.

## Highlights

* The `jasmine-core` dependency has been updated to 4.0.0
* ES module support is enabled by default.
* Node 10 and 12.0-12.16 are no longer supported.

## Breaking changes

* Node versions older than 12.17 are no longer supported because they have
  insufficient support for interop between ES modules and CommonJS modules.

* Beginning with this release, everything not documented in the
  [API reference](https://jasmine.github.io/api/npm/4.0/Jasmine) is considered
  a private API.

* ES module support is enabled by default, but can still be disabled by
  adding `jsLoader: "require"` to the configuration. `jsLoader: "import"` is
  now a no-op.

  This change breaks loading of files with extensions that aren't supported by
  dynamic `import()`, such as `.jsx`, although that has been subsequently fixed
  in 4.0.1. If you have specs or source files with such extensions, please
  update to at least 4.0.1. Alternately you can either rename the files to
  `.js` or add `jsLoader: "require"` to your Jasmine config file. 

* Config files can be ES modules. This is a breaking change because it requires
  `Jasmine#loadConfigFile` to be async.

* The `--fail-fast` CLI flag now causes Jasmine to stop spec execution on the
  first expectation failure as well as stopping suite execution on the first
  spec failure.

* The ambiguously named `--stop-on-failure` CLI flag is no longer supported.

* Failure to load or instantiate a reporter is a fatal error, not just a warning.

* Relative reporter paths are resolved based on the working directory rather
  than the location of the module inside Jasmine that calls `require()`.

* The `jasmine` command now uses distinct exit codes for various types of non-success:
  * 1 for anything unexpected, i.e. Jasmine didn't run to completion
  * 2 for incomplete (focused specs/suites but no failures)
  * 3 for failed (spec/suite failures)
  * Other nonzero exit codes may be used for other purposes. Code that checks
    the exit code of the `jasmine` command should not treat any value other than
    0 as success.
  * Fixes [#154](https://github.com/jasmine/jasmine-npm/issues/154).

* `Jasmine#onComplete` is no longer supported. To run code after execution
  finishes, set the Jasmine instance's `exitOnCompletion` to false and use the
  promise returned by `Jasmine#execute`. See the 
  [API reference for `execute`](https://jasmine.github.io/api/npm/4.0/Jasmine.html#execute)
  for more information.

## New features and bugfixes

* Files listed in the `requires` config property can be ES modules

* Reporters specified with `--reporter=` can be ES modules.

* Allow use without creating globals.
  * See <https://jasmine.github.io/api/npm/4.0/JasmineOptions.html#globals>.
  * Fixes [jasmine/jasmine#1235](https://github.com/jasmine/jasmine/issues/1235).

* Autodiscover spec/support/jasmine.js as well as spec/support/jasmine.json.

* Moved `stopSpecOnExpectationFailure` and `random` to `env` in the sample
  config generated by `jasmine init`.

* Top suite failures are included in the failure count displayed by the default
  `ConsoleReporter`.

* Added support for the debug logging feature introduced in `jasmine-core` 4.0.0.

* Fixed handling of module paths containing `..` on OS X.
  
## Internal improvements

* Use the promise returned from `Env#execute` to determine when suite execution
  is finished and obtain the overall result.

* Removed unnecessary code to filter Jasmine's frames from stack traces. The same
  filtering has been done in jasmine-core since 3.0.

* Inlined loadConfig.js back into command.js to resolve naming conflicts.

## Supported environments

The jasmine NPM package has been tested on Node 12.17-12.22, 14, and 16.


------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
