/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceDiscover;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverNamesInFile
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(class$org$apache$commons$discovery$resource$names$DiscoverNamesInFile == null ? (class$org$apache$commons$discovery$resource$names$DiscoverNamesInFile = DiscoverNamesInFile.class$("org.apache.commons.discovery.resource.names.DiscoverNamesInFile")) : class$org$apache$commons$discovery$resource$names$DiscoverNamesInFile);
    private ResourceDiscover discoverResources;
    static /* synthetic */ Class class$org$apache$commons$discovery$resource$names$DiscoverNamesInFile;

    public static void setLog(Log _log) {
        log = _log;
    }

    public DiscoverNamesInFile() {
        this.discoverResources = new DiscoverResources();
    }

    public DiscoverNamesInFile(ClassLoaders loaders) {
        this.discoverResources = new DiscoverResources(loaders);
    }

    public DiscoverNamesInFile(ResourceDiscover discoverer) {
        this.discoverResources = discoverer;
    }

    public void setDiscoverer(ResourceDiscover discover) {
        this.discoverResources = discover;
    }

    public ResourceDiscover getDiscover() {
        return this.discoverResources;
    }

    public ResourceNameIterator findResourceNames(final String fileName) {
        if (log.isDebugEnabled()) {
            log.debug("find: fileName='" + fileName + "'");
        }
        return new ResourceNameIterator(){
            private ResourceIterator files;
            private int idx;
            private Vector classNames;
            private String resource;
            {
                this.files = DiscoverNamesInFile.this.getDiscover().findResources(fileName);
                this.idx = 0;
                this.classNames = null;
                this.resource = null;
            }

            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClassName();
                }
                return this.resource != null;
            }

            public String nextResourceName() {
                String element = this.resource;
                this.resource = null;
                return element;
            }

            private String getNextClassName() {
                if (this.classNames == null || this.idx >= this.classNames.size()) {
                    this.classNames = this.getNextClassNames();
                    this.idx = 0;
                    if (this.classNames == null) {
                        return null;
                    }
                }
                String className = (String)this.classNames.get(this.idx++);
                if (log.isDebugEnabled()) {
                    log.debug("getNextClassResource: next class='" + className + "'");
                }
                return className;
            }

            private Vector getNextClassNames() {
                while (this.files.hasNext()) {
                    Vector results = DiscoverNamesInFile.this.readServices(this.files.nextResource());
                    if (results == null || results.size() <= 0) continue;
                    return results;
                }
                return null;
            }
        };
    }

    private Vector readServices(Resource info) {
        Vector<String> results = new Vector<String>();
        InputStream is = info.getResourceAsStream();
        if (is != null) {
            try {
                try {
                    BufferedReader rd;
                    try {
                        rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        rd = new BufferedReader(new InputStreamReader(is));
                    }
                    try {
                        String serviceImplName;
                        while ((serviceImplName = rd.readLine()) != null) {
                            int idx = e.indexOf(35);
                            if (idx >= 0) {
                                serviceImplName = e.substring(0, idx);
                            }
                            if ((serviceImplName = serviceImplName.trim()).length() == 0) continue;
                            results.add(serviceImplName);
                        }
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        rd.close();
                        throw throwable;
                    }
                    rd.close();
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

