/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.turbine.services.logging.BaseLogger;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.util.RunData;

public class FileLogger
extends BaseLogger {
    protected static Hashtable globalFilesTable = new Hashtable();
    protected Hashtable localFilesTable;
    protected String lf = System.getProperty("line.separator", "\n");

    public void init(LoggingConfig loggingConfig) {
        super.init(loggingConfig);
    }

    protected void configureFiles(LoggingConfig loggingConfig) {
        Vector files = loggingConfig.getFiles();
        Enumeration fileList = files.elements();
        while (fileList.hasMoreElements()) {
            FileWriter writer;
            String path = (String)fileList.nextElement();
            String pathTmp = ((ServletContext)loggingConfig.getServletContext()).getRealPath(path);
            if (pathTmp != null) {
                path = pathTmp;
            }
            if ((writer = (FileWriter)globalFilesTable.get(path)) == null) {
                try {
                    writer = new FileWriter(path, true);
                    globalFilesTable.put(path, writer);
                }
                catch (Exception e) {
                    continue;
                }
            }
            this.localFilesTable.put(path, writer);
        }
    }

    protected void configureConsole(LoggingConfig loggingConfig) {
        this.console = loggingConfig.getConsole();
    }

    public boolean checkLogger() {
        if (this.console) {
            return true;
        }
        return this.localFilesTable.size() > 0;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        Enumeration files = this.localFilesTable.elements();
        while (files.hasMoreElements()) {
            FileWriter fw = (FileWriter)files.nextElement();
            try {
                fw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(String message) {
        this.log(1, message, null, null);
    }

    public void debug(String message, Throwable t) {
        this.log(1, message, null, t);
    }

    public void debug(String message, RunData data) {
        this.log(1, message, data, null);
    }

    public void debug(String message, RunData data, Throwable t) {
        this.log(1, message, data, t);
    }

    public void info(String message) {
        this.log(2, message, null, null);
    }

    public void info(String message, Throwable t) {
        this.log(2, message, null, t);
    }

    public void info(String message, RunData data) {
        this.log(2, message, data, null);
    }

    public void info(String message, RunData data, Throwable t) {
        this.log(2, message, data, t);
    }

    public void warn(String message) {
        this.log(3, message, null, null);
    }

    public void warn(String message, Throwable t) {
        this.log(3, message, null, t);
    }

    public void warn(String message, RunData data) {
        this.log(3, message, data, null);
    }

    public void warn(String message, RunData data, Throwable t) {
        this.log(3, message, data, t);
    }

    public void error(String message) {
        this.log(4, message, null, null);
    }

    public void error(String message, Throwable e) {
        this.log(4, message, null, e);
    }

    public void error(Throwable e) {
        this.log(4, null, null, e);
    }

    public void error(String message, RunData data) {
        this.log(4, message, data, null);
    }

    public void error(String message, RunData data, Throwable e) {
        this.log(4, message, data, e);
    }

    protected void log(int level, String message, RunData data, Throwable e) {
        String levelS;
        if (level < this.logLevel) {
            return;
        }
        switch (level) {
            case 1: {
                levelS = "DEBUG";
                break;
            }
            case 2: {
                levelS = "INFO";
                break;
            }
            case 3: {
                levelS = "WARN";
                break;
            }
            case 4: {
                levelS = "ERROR";
                break;
            }
            default: {
                levelS = "DEBUG";
            }
        }
        this.logAll(levelS, message, data, e);
    }

    protected void logAll(String level, String description, RunData data, Throwable t) {
        Date date = new Date();
        StringBuffer logEntry = new StringBuffer();
        logEntry.append("[");
        logEntry.append(date.toString());
        logEntry.append("] -- ");
        logEntry.append(level);
        logEntry.append(" -- ");
        logEntry.append(description);
        if (data != null) {
            logEntry.append(" -- ");
            logEntry.append(this.runDataFilter.getString(data));
        }
        if (t != null) {
            logEntry.append(this.lf);
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(ostr, true);
            out.write(logEntry.toString());
            out.write("\tException:  ");
            out.write(t.toString());
            out.write(this.lf + "\tStack Trace follows:" + this.lf + "\t");
            t.printStackTrace(out);
            logEntry = new StringBuffer(ostr.toString());
        }
        if (this.console) {
            System.out.println(logEntry.toString());
        }
        logEntry.append(this.lf);
        Enumeration logFile = this.localFilesTable.elements();
        while (logFile.hasMoreElements()) {
            FileWriter fw;
            FileWriter fileWriter = fw = (FileWriter)logFile.nextElement();
            synchronized (fileWriter) {
                try {
                    fw.write(logEntry.toString(), 0, logEntry.length());
                    fw.flush();
                }
                catch (IOException e) {
                    System.out.println("Cannot log message: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public FileLogger() {
        this.localFilesTable = new Hashtable();
    }
}

