/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;
import org.chefproject.core.Edit;
import org.chefproject.core.Resource;
import org.chefproject.core.StorageUser;
import org.chefproject.util.Sql;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseDbDoubleStorage {
    protected String m_containerTableName = null;
    protected String m_containerTableIdField = null;
    protected String m_resourceTableName = null;
    protected String m_resourceTableIdField = null;
    protected String m_resourceTableContainerIdField = null;
    protected String[] m_resourceTableOtherFields = null;
    protected String m_resourceTableOrderField = null;
    protected String m_resourceEntryTagName = null;
    protected String m_containerEntryTagName = null;
    protected boolean m_locksAreInDb = true;
    protected StorageUser m_user = null;
    protected Hashtable m_locks = null;
    protected static final String[] M_containerExtraFields = new String[]{"NEXT_ID"};

    public BaseDbDoubleStorage(String containerTableName, String containerTableIdField, String resourceTableName, String resourceTableIdField, String resourceTableContainerIdField, String resourceTableOrderField, String[] resourceTableOtherFields, boolean locksInDb, String containerEntryName, String resourceEntryName, StorageUser user) {
        this.m_containerTableName = containerTableName;
        this.m_containerTableIdField = containerTableIdField;
        this.m_resourceTableName = resourceTableName;
        this.m_resourceTableIdField = resourceTableIdField;
        this.m_resourceTableContainerIdField = resourceTableContainerIdField;
        this.m_resourceTableOrderField = resourceTableOrderField;
        this.m_resourceTableOtherFields = resourceTableOtherFields;
        this.m_locksAreInDb = locksInDb;
        this.m_containerEntryTagName = containerEntryName;
        this.m_resourceEntryTagName = resourceEntryName;
        this.m_user = user;
    }

    public void open() {
        this.m_locks = new Hashtable();
    }

    public void close() {
        if (!this.m_locks.isEmpty()) {
            Log.warn("chef", this + ".close(): locks remain!");
        }
        this.m_locks.clear();
        this.m_locks = null;
    }

    protected Resource readContainer(String xml) {
        try {
            Document doc = Xml.readDocumentFromString(xml);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals(this.m_containerEntryTagName)) {
                Log.warn("chef", this + ".readContainer(): not = " + this.m_containerEntryTagName + " : " + root.getTagName());
                return null;
            }
            Resource entry = this.m_user.newContainer(root);
            return entry;
        }
        catch (Exception e) {
            Log.debug("chef", this + ".readContainer(): ", (Throwable)e);
            return null;
        }
    }

    public boolean checkContainer(String ref) {
        String sql = "select " + this.m_containerTableIdField + "  from " + this.m_containerTableName + " where ( " + this.m_containerTableIdField + " = '" + Validator.escapeSql(ref) + "' )";
        List ids = Sql.dbRead(sql);
        return !ids.isEmpty();
    }

    public Resource getContainer(String ref) {
        Resource entry = null;
        String sql = "select XML from " + this.m_containerTableName + " where ( " + this.m_containerTableIdField + " = '" + Validator.escapeSql(ref) + "' )";
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            entry = this.readContainer((String)xml.get(0));
        }
        return entry;
    }

    public List getAllContainers() {
        Vector<Resource> all = new Vector<Resource>();
        String sql = "select XML from " + this.m_containerTableName;
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            int i = 0;
            while (i < xml.size()) {
                Resource entry = this.readContainer((String)xml.get(i));
                if (entry != null) {
                    all.add(entry);
                }
                ++i;
            }
        }
        return all;
    }

    public Edit putContainer(String ref) {
        Resource entry = this.m_user.newContainer(ref);
        Document doc = Xml.createDocument();
        entry.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "insert into " + this.m_containerTableName + this.insertFields(this.m_containerTableIdField, null, M_containerExtraFields, "XML") + " values ( " + "'" + Validator.escapeSql(entry.getReference()) + "'" + ",'0'" + ", ? )";
        boolean ok = Sql.dbWrite(statement, xml);
        if (!ok) {
            return null;
        }
        Edit edit = this.editContainer(ref);
        if (edit == null) {
            Log.warn("chef", this + ".putContainer(): didn't get a lock!");
            return null;
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit editContainer(String ref) {
        Edit edit = null;
        if (this.m_locksAreInDb) {
            StringBuffer result;
            String statement = "select XML from " + this.m_containerTableName + " where ( " + this.m_containerTableIdField + " = '" + Validator.escapeSql(ref) + "' )" + " for update nowait";
            DBConnection lock = Sql.dbReadLock(statement, result = new StringBuffer());
            if (lock == null || result.length() == 0) {
                return null;
            }
            Resource entry = this.readContainer(result.toString());
            edit = this.m_user.newContainerEdit(entry);
            this.m_locks.put(entry.getReference(), lock);
        } else {
            Resource entry = this.getContainer(ref);
            if (entry == null) {
                return null;
            }
            Hashtable hashtable = this.m_locks;
            synchronized (hashtable) {
                block8: {
                    if (!this.m_locks.containsKey(entry.getReference())) break block8;
                    Edit edit2 = null;
                    return edit2;
                }
                edit = this.m_user.newContainerEdit(entry);
                this.m_locks.put(entry.getReference(), edit);
            }
        }
        return edit;
    }

    public void commitContainer(Edit edit) {
        Document doc = Xml.createDocument();
        edit.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "update " + this.m_containerTableName + " set XML = ?" + " where " + this.m_containerTableIdField + " = " + "'" + Validator.escapeSql(edit.getReference()) + "'";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".commitContainer(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, null, xml, lock);
        } else {
            Sql.dbWrite(statement, xml);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void cancelContainer(Edit edit) {
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".cancelContainer(): edit not in locks");
                return;
            }
            Sql.dbCancel(lock);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void removeContainer(Edit edit) {
        String statement = "delete from " + this.m_containerTableName + " where " + this.m_containerTableIdField + " = " + "'" + Validator.escapeSql(edit.getReference()) + "'";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".removeContainer(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, null, null, lock);
        } else {
            Sql.dbWrite(statement);
        }
        this.m_locks.remove(edit.getReference());
    }

    protected Resource readResource(Resource container, String xml) {
        try {
            Document doc = Xml.readDocumentFromString(xml);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals(this.m_resourceEntryTagName)) {
                Log.warn("chef", this + ".readResource(): not = " + this.m_resourceEntryTagName + " : " + root.getTagName());
                return null;
            }
            Resource entry = this.m_user.newResource(container, root);
            return entry;
        }
        catch (Exception e) {
            Log.debug("chef", this + ".readResource(): ", (Throwable)e);
            return null;
        }
    }

    public boolean checkResource(Resource container, String id) {
        String sql = "select " + this.m_resourceTableIdField + "  from " + this.m_resourceTableName + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + " and ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )";
        List ids = Sql.dbRead(sql);
        return !ids.isEmpty();
    }

    public Resource getResource(Resource container, String id) {
        Resource entry = null;
        String sql = "select XML from " + this.m_resourceTableName + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + " and ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )";
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            entry = this.readResource(container, (String)xml.get(0));
        }
        return entry;
    }

    public List getAllResources(Resource container) {
        Vector<Resource> all = new Vector<Resource>();
        String sql = "select XML from " + this.m_resourceTableName + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + (this.m_resourceTableOrderField != null ? " order by " + this.m_resourceTableOrderField + " asc" : "");
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            int i = 0;
            while (i < xml.size()) {
                Resource entry = this.readResource(container, (String)xml.get(i));
                if (entry != null) {
                    all.add(entry);
                }
                ++i;
            }
        }
        return all;
    }

    public Edit putResource(Resource container, String id, Object[] others) {
        Resource entry = this.m_user.newResource(container, id, others);
        Object[] fields = this.m_user.storageFields(entry);
        Document doc = Xml.createDocument();
        entry.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "insert into " + this.m_resourceTableName + this.insertFields(this.m_containerTableIdField, this.m_resourceTableIdField, this.m_resourceTableOtherFields, "XML") + " values ( " + "'" + Validator.escapeSql(container.getReference()) + "'," + "'" + Validator.escapeSql(entry.getId()) + "'," + this.valuesParams(this.m_resourceTableOtherFields) + " ? )";
        boolean ok = Sql.dbWrite(statement, fields, xml);
        if (!ok) {
            return null;
        }
        Edit edit = this.editResource(container, id);
        if (edit == null) {
            Log.warn("chef", this + ".putResource(): didn't get a lock!");
            return null;
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit editResource(Resource container, String id) {
        Edit edit = null;
        if (this.m_locksAreInDb) {
            StringBuffer result;
            String statement = "select XML from " + this.m_resourceTableName + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + " and ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )" + " for update nowait";
            DBConnection lock = Sql.dbReadLock(statement, result = new StringBuffer());
            if (lock == null || result.length() == 0) {
                return null;
            }
            Resource entry = this.readResource(container, result.toString());
            edit = this.m_user.newResourceEdit(container, entry);
            this.m_locks.put(entry.getReference(), lock);
        } else {
            Resource entry = this.getResource(container, id);
            if (entry == null) {
                return null;
            }
            Hashtable hashtable = this.m_locks;
            synchronized (hashtable) {
                block8: {
                    if (!this.m_locks.containsKey(entry.getReference())) break block8;
                    Edit edit2 = null;
                    return edit2;
                }
                edit = this.m_user.newResourceEdit(container, entry);
                this.m_locks.put(entry.getReference(), edit);
            }
        }
        return edit;
    }

    public void commitResource(Resource container, Edit edit) {
        Object[] fields = this.m_user.storageFields(edit);
        Document doc = Xml.createDocument();
        edit.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "update " + this.m_resourceTableName + " set " + this.updateSet(this.m_resourceTableOtherFields) + " XML = ?" + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + " and ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(edit.getId()) + "' )";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".commitResource(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, fields, xml, lock);
        } else {
            Sql.dbWrite(statement, fields, xml);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void cancelResource(Resource container, Edit edit) {
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".cancelResource(): edit not in locks");
                return;
            }
            Sql.dbCancel(lock);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void removeResource(Resource container, Edit edit) {
        String statement = "delete from " + this.m_resourceTableName + " where (" + this.m_resourceTableContainerIdField + " ='" + Validator.escapeSql(container.getReference()) + "' )" + " and ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(edit.getId()) + "' )";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".removeResource(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, null, null, lock);
        } else {
            Sql.dbWrite(statement);
        }
        this.m_locks.remove(edit.getReference());
    }

    protected String valuesParams(String[] fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < fields.length) {
            buf.append(" ?,");
            ++i;
        }
        return buf.toString();
    }

    protected String updateSet(String[] fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < fields.length) {
            buf.append(fields[i] + " = ?,");
            ++i;
        }
        return buf.toString();
    }

    protected String insertFields(String before1, String before2, String[] fields, String after) {
        StringBuffer buf = new StringBuffer();
        buf.append(" (");
        buf.append(before1);
        buf.append(",");
        if (before2 != null) {
            buf.append(before2);
            buf.append(",");
        }
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                buf.append(fields[i] + ",");
                ++i;
            }
        }
        buf.append(after);
        buf.append(")");
        return buf.toString();
    }
}

