% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltype.R
\name{make.calltype}
\alias{make.calltype}
\title{Create calltype of the imputation model}
\usage{
make.calltype(calltype, predictorMatrix, formulas, priority = "pred")
}
\arguments{
\item{calltype}{A character vector of length equal to the number of blocks in \code{predictorMatrix}.
Each element specifies how the imputation model for the corresponding block is defined.
Valid values are \code{"pred"} and \code{"formula"}. If \code{NULL}, the calltype
will be \code{"pred"} for all blocks, unless \code{priority} is \code{"formula"}.}

\item{predictorMatrix}{A matrix specifying the predictors for each block. Each row corresponds
to a block, and each column corresponds to a variable. Non-zero entries indicate that the variable
is used as a predictor for the block.}

\item{formulas}{A list of formulas, where each element corresponds to a block in \code{predictorMatrix}.
If a formula is provided for a block, the corresponding \code{calltype} entry is set to \code{"formula"}.
If \code{NULL}, formulas are not used to modify \code{calltype}.}

\item{priority}{A character string specifying the default value for \code{calltype} when it is \code{NULL}.
Defaults to \code{"pred"}. If \code{priority == "formula"}, the calltype will be \code{"formula"}
for blocks found in \code{formulas} with a matching name.}
}
\value{
A character vector of length equal to the number of rows in \code{predictorMatrix}.
Each element is either \code{"pred"} or \code{"formula"}, indicating how the imputation model
is specified for the corresponding block.
}
\description{
The helper \code{make.calltype()} creates a vector that identifies per block if
the imputation model is taken from \code{predictorMatrix} or \code{formulas}. The
function is used internally by \code{mice()}.
}
\examples{
# Example predictorMatrix
predictorMatrix <- matrix(1, nrow = 3, ncol = 3,
 dimnames = list(c("block1", "block2", "block3"), c("x1", "x2", "y")))
predictorMatrix[1, 3] <- 0

# Case 1: No calltype or formulas specified
make.calltype(NULL, predictorMatrix, NULL)

# Case 2: Formulas provided
formulas <- list(
  NULL,
  y ~ x1 + x2,
  NULL
)
make.calltype(NULL, predictorMatrix, formulas)

# Case 3: Custom calltype
calltype <- c("pred", "formula", "pred")
make.calltype(calltype, predictorMatrix, NULL)

}
