# Print Arch Linux packages providing given GStreamer decoders list.
# USAGE: dependencies_gstreamer_list_archlinux $dependencies_gstreamer
dependencies_gstreamer_list_archlinux() {
	local dependencies_gstreamer
	dependencies_gstreamer="$1"

	local package package_architecture dependency_gstreamer
	package=$(current_package)
	package_architecture=$(package_architecture "$package")
	while read -r dependency_gstreamer; do
		case "$package_architecture" in
			('32')
				dependencies_gstreamer_single_archlinux_32bit "$dependency_gstreamer"
			;;
			(*)
				dependencies_gstreamer_single_archlinux "$dependency_gstreamer"
			;;
		esac
	done <<- EOL
	$(printf '%s' "$dependencies_gstreamer")
	EOL
}

# Print Arch Linux packages providing given single GStreamer decoder.
# USAGE: dependencies_gstreamer_single_archlinux $dependency_gstreamer
dependencies_gstreamer_single_archlinux() {
	local dependency_gstreamer
	dependency_gstreamer="$1"

	local package_names
	case "$dependency_gstreamer" in
		('audioconvert')
			package_names='
			gst-plugins-base'
		;;
		('avidemux')
			package_names='
			gst-plugins-good'
		;;
		('decodebin')
			package_names='
			gst-plugins-base'
		;;
		('deinterlace')
			package_names='
			gst-plugins-good'
		;;
		('application/x-id3')
			package_names='
			gst-plugins-good'
		;;
		('audio/mpeg, mpegversion=(int)1, layer=(int)3')
			package_names='
			gst-plugins-good'
		;;
		( \
			'audio/x-wma' | \
			'audio/x-wma, wmaversion=(int)1' \
		)
			package_names='
			gst-libav'
		;;
		('video/mpeg, systemstream=(boolean)true, mpegversion=(int)1')
			package_names='
			gst-plugins-ugly
			gst-plugins-bad'
		;;
		('video/quicktime, variant=(string)iso')
			package_names='
			gst-plugins-good
			gst-libav'
		;;
		('video/x-ms-asf')
			package_names='
			gst-plugins-ugly
			x-ms-asf'
		;;
		('video/x-msvideo')
			package_names='
			gst-plugins-good
			gst-libav'
		;;
		( \
			'video/x-wmv' | \
			'video/x-wmv, wmvversion=(int)1' \
		)
			package_names='
			gst-libav'
		;;
		(*)
			dependencies_unknown_gstreamer_media_formats_add "$dependency_gstreamer"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

# Print 32-bit Arch Linux packages providing given single GStreamer decoder.
# USAGE: dependencies_gstreamer_single_archlinux_32bit $dependency_gstreamer
dependencies_gstreamer_single_archlinux_32bit() {
	local dependency_gstreamer
	dependency_gstreamer="$1"

	local package_names
	case "$dependency_gstreamer" in
		('audioconvert')
			package_names='
			lib32-gst-plugins-base'
		;;
		('avidemux')
			package_names='
			lib32-gst-plugins-good'
		;;
		('decodebin')
			package_names='
			lib32-gst-plugins-base'
		;;
		('deinterlace')
			package_names='
			lib32-gst-plugins-good'
		;;
		('application/x-id3')
			package_names='
			lib32-gst-plugins-good'
		;;
		('audio/mpeg, mpegversion=(int)1, layer=(int)3')
			package_names='
			lib32-gst-plugins-good'
		;;
		( \
			'audio/x-wma' | \
			'audio/x-wma, wmaversion=(int)1' \
		)
			package_names='
			lib32-gst-libav'
		;;
		('video/mpeg, systemstream=(boolean)true, mpegversion=(int)1')
			package_names='
			lib32-gst-plugins-ugly
			lib32-gst-plugins-bad'
		;;
		('video/quicktime, variant=(string)iso')
			package_names='
			lib32-gst-plugins-good
			lib32-gst-libav'
		;;
		('video/x-ms-asf')
			package_names='
			lib32-gst-plugins-ugly
			lib32-gst-libav'
		;;
		('video/x-msvideo')
			package_names='
			lib32-gst-plugins-good
			lib32-gst-libav'
		;;
		( \
			'video/x-wmv' | \
			'video/x-wmv, wmvversion=(int)1' \
		)
			package_names='
			lib32-gst-libav'
		;;
		(*)
			dependencies_unknown_gstreamer_media_formats_add "$dependency_gstreamer"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

