# Print Debian packages providing given commands list.
# USAGE: dependencies_commands_list_debian $dependencies_commands
dependencies_commands_list_debian() {
	local dependencies_commands
	dependencies_commands="$1"

	local dependency_command
	while read -r dependency_command; do
		dependencies_command_single_debian "$dependency_command"
	done <<- EOL
	$(printf '%s' "$dependencies_commands")
	EOL
}

# Print Debian packages providing given single command.
# USAGE: dependencies_command_single_debian $dependency_command
dependencies_command_single_debian() {
	local dependency_command
	dependency_command="$1"

	local package_names
	case "$dependency_command" in
		('7za')
			package_names='
			7zip | p7zip-full'
		;;
		('corsix-th')
			package_names='
			corsix-th'
		;;
		('dos2unix')
			package_names='
			dos2unix'
		;;
		('dosbox')
			package_names='
			dosbox'
		;;
		('dxvk-setup | winetricks')
			local package package_architecture
			package=$(current_package)
			package_architecture=$(package_architecture "$package")
			case "$package_architecture" in
				('64')
					package_names='
					dxvk-wine64 | winetricks
					dxvk | winetricks'
				;;
				('32')
					package_names='
					dxvk-wine32 | winetricks
					dxvk | winetricks'
				;;
			esac
		;;
		('godot3-runner')
			package_names='
			godot3-runner'
		;;
		('firefox')
			package_names='
			firefox-esr | firefox'
		;;
		('java')
			package_names='
			default-jre | java-runtime'
		;;
		('julius')
			package_names='
			julius'
		;;
		('mono')
			package_names='
			mono-runtime'
		;;
		('mpv')
			package_names='
			mpv:amd64 | mpv'
		;;
		('openmw-iniimporter')
			package_names='
			openmw-launcher'
		;;
		('openmw-launcher')
			package_names='
			openmw-launcher'
		;;
		('pidwait')
			package_names='
			procps:amd64 | procps'
		;;
		('pulseaudio')
			package_names='
			pulseaudio:amd64 | pulseaudio'
		;;
		('python3')
			package_names='
			python3'
		;;
		('renpy')
			package_names='
			renpy'
		;;
		('scummvm')
			package_names='
			scummvm'
		;;
		('sed')
			# The Debian policy advises against adding dependencies on packages that are part of the required set.
			package_names=''
		;;
		('setxkbmap')
			package_names='
			x11-xkb-utils'
		;;
		('terminal_wrapper')
			local package package_architecture
			package=$(current_package)
			package_architecture=$(package_architecture "$package")
			case "$package_architecture" in
				('32')
					package_names='
					xterm:amd64 | xterm | x-terminal-emulator:amd64 | x-terminal-emulator'
				;;
				('64')
					package_names='
					xterm | x-terminal-emulator'
				;;
			esac
		;;
		('vcmilauncher')
			package_names='
			vcmi'
		;;
		('wine')
			local package package_architecture
			package=$(current_package)
			package_architecture=$(package_architecture "$package")
			case "$package_architecture" in
				('32')
					package_names='
					wine32 | wine32-development | wine-stable-i386 | wine-devel-i386 | wine-staging-i386
					wine:amd64 | wine'
				;;
				('64')
					package_names='wine64 | wine64-development | wine-stable-amd64 | wine-devel-amd64 | wine-staging-amd64
					wine'
				;;
			esac
		;;
		('winetricks')
			package_names='
			winetricks'
		;;
		('xgamma')
			package_names='
			x11-xserver-utils:amd64 | x11-xserver-utils'
		;;
		('xrandr')
			package_names='
			x11-xserver-utils:amd64 | x11-xserver-utils'
		;;
		(*)
			dependencies_unknown_command_add "$dependency_command"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

