#include <string>
#include <vector>
#include <set>
#include <map>
#include <utility>
#include <charm++.h>
#include <ck.h>
#include <ckarray.h>

///////////////////////////////////////////////////////////////////
// WARNING: THIS FILE IS GENERATED BY cp_effects.pl
//          ANY CHANGES TO THIS FILE MAY BE LOST 
///////////////////////////////////////////////////////////////////


#ifndef __CP_EFFECTS_H__
#define __CP_EFFECTS_H__

#if CMK_WITH_CONTROLPOINT

namespace ControlPoint {

  enum DIRECTION {EFF_DEC, EFF_INC};

  class ControlPointAssociation {
  public:
    std::set<int> EntryID;
    std::set<int> ArrayGroupIdx;
      ControlPointAssociation() {
	// nothing here yet
      }
  };
  
  class ControlPointAssociatedEntry : public ControlPointAssociation {
    public :
	ControlPointAssociatedEntry() : ControlPointAssociation() {}

	ControlPointAssociatedEntry(int epid) : ControlPointAssociation() {
	  EntryID.insert(epid);
	}    
  };
  
  class ControlPointAssociatedArray : public ControlPointAssociation {
  public:
    ControlPointAssociatedArray() : ControlPointAssociation() {}

    ControlPointAssociatedArray(const CProxy_ArrayBase &a) : ControlPointAssociation() {
      CkGroupID aid = a.ckGetArrayID();
      int groupIdx = aid.idx;
      ArrayGroupIdx.insert(groupIdx);
    }
  };
  
  class NoControlPointAssociation : public ControlPointAssociation { };


  void initControlPointEffects();
  ControlPointAssociatedEntry assocWithEntry(const int entry);
  ControlPointAssociatedArray assocWithArray(const CProxy_ArrayBase &array);

 //                 effect               cp                 direction           associations
  typedef std::map<std::string,std::map<std::string, std::pair<int, std::vector<ControlPoint::ControlPointAssociation> > > > cp_effect_map;

 //                   cp                          direction           associations
 //  typedef std::map<std::string, std::vector<std::pair<int, ControlPoint::ControlPointAssociation> > > cp_name_map;


namespace EffectIncrease {
	void Priority(std::string name, const ControlPoint::ControlPointAssociation &a);
	void Priority(std::string name);
	void MemoryConsumption(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MemoryConsumption(std::string name);
	void GrainSize(std::string name, const ControlPoint::ControlPointAssociation &a);
	void GrainSize(std::string name);
	void ComputeDurations(std::string name, const ControlPoint::ControlPointAssociation &a);
	void ComputeDurations(std::string name);
	void FlopRate(std::string name, const ControlPoint::ControlPointAssociation &a);
	void FlopRate(std::string name);
	void NumComputeObjects(std::string name, const ControlPoint::ControlPointAssociation &a);
	void NumComputeObjects(std::string name);
	void NumMessages(std::string name, const ControlPoint::ControlPointAssociation &a);
	void NumMessages(std::string name);
	void MessageSizes(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MessageSizes(std::string name);
	void MessageOverhead(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MessageOverhead(std::string name);
	void UnnecessarySyncronization(std::string name, const ControlPoint::ControlPointAssociation &a);
	void UnnecessarySyncronization(std::string name);
	void Concurrency(std::string name, const ControlPoint::ControlPointAssociation &a);
	void Concurrency(std::string name);
	void PotentialOverlap(std::string name, const ControlPoint::ControlPointAssociation &a);
	void PotentialOverlap(std::string name);
	void LoadBalancingPeriod(std::string name, const ControlPoint::ControlPointAssociation &a);
	void LoadBalancingPeriod(std::string name);
	void GPUOffloadedWork(std::string name, const ControlPoint::ControlPointAssociation &a);
	void GPUOffloadedWork(std::string name);

}

namespace EffectDecrease {
	void Priority(std::string name, const ControlPoint::ControlPointAssociation &a);
	void Priority(std::string name);
	void MemoryConsumption(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MemoryConsumption(std::string name);
	void GrainSize(std::string name, const ControlPoint::ControlPointAssociation &a);
	void GrainSize(std::string name);
	void ComputeDurations(std::string name, const ControlPoint::ControlPointAssociation &a);
	void ComputeDurations(std::string name);
	void FlopRate(std::string name, const ControlPoint::ControlPointAssociation &a);
	void FlopRate(std::string name);
	void NumComputeObjects(std::string name, const ControlPoint::ControlPointAssociation &a);
	void NumComputeObjects(std::string name);
	void NumMessages(std::string name, const ControlPoint::ControlPointAssociation &a);
	void NumMessages(std::string name);
	void MessageSizes(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MessageSizes(std::string name);
	void MessageOverhead(std::string name, const ControlPoint::ControlPointAssociation &a);
	void MessageOverhead(std::string name);
	void UnnecessarySyncronization(std::string name, const ControlPoint::ControlPointAssociation &a);
	void UnnecessarySyncronization(std::string name);
	void Concurrency(std::string name, const ControlPoint::ControlPointAssociation &a);
	void Concurrency(std::string name);
	void PotentialOverlap(std::string name, const ControlPoint::ControlPointAssociation &a);
	void PotentialOverlap(std::string name);
	void LoadBalancingPeriod(std::string name, const ControlPoint::ControlPointAssociation &a);
	void LoadBalancingPeriod(std::string name);
	void GPUOffloadedWork(std::string name, const ControlPoint::ControlPointAssociation &a);
	void GPUOffloadedWork(std::string name);

}


} //namespace ControlPoint

CkpvExtern(ControlPoint::cp_effect_map, cp_effects);
//CkpvExtern(ControlPoint::cp_name_map, cp_names);

#endif
#endif
